<?php

class navigator {
	public $all = 0;
	public $page;
	public $start = 0;
	public $end = 0;
	public $limit = 'LIMIT 0';
	//Шаблоны
	//Форма быстрого перехода
	public $htmlForm =  '<div class="hr"></div><form action="%s" method="post"><div>На стр: <input type="text" name="page" size="2" value="%s"><input type="submit" name="" value="&gt;"></div></form>';
    //Кнопка Назад
	public $buttonBack = '<span class="next">&laquo; <a href="%spage=%s">Назад</a></span>';
	//Имя кнопкм Назад (если вернутся назад уже нельзя, будет выводится прото текст Назад)
	public $buttonBackName = '&laquo;Назад';
	//Кнопка Вперед
	public $buttonForward = '<span class="next"><a href="%spage=%s">Далее</a> &raquo;</span><br />';
	//Имя кнопкм Вперед (аналогично $buttonBackName)
	public $buttonForwardName = 'Далее&raquo;<br />';
	//Разделитель между кнопками Назад Вперед, а вдруг захочется изменить :D
	public $separator = ' ';
	//Блок в который будет помешен список страниц 1,2,3...
	public $listStr = '<div class="hr"></div>Стр: %s <a href="%spage=%s" title="Далее"><span class="next">&raquo;</span></a><br />';
	//Блок для метода Navi в котором будет выводится все элементы (%1$s кнопки Назад Вперед, %2$s список страниц, %3$s Форма быстрого перехода)
	public $blocAllNavi = '%1$s %2$s %3$s';

   /*$all - Всего записей, $pnumber - сколько выводить на стр, $skript - Путь к странице*/
    function __construct($all, $pnumber, $skript = '')
    {
    	$this->all = $all;
        $this->skript = $skript == '' ? $_SERVER['SCRIPT_NAME'] . '?' : rtrim($skript);
        $this->page = isset($_REQUEST['page']) && (int)$_REQUEST['page'] ? (int)$_REQUEST['page'] : 1;
        $this->num_pages = ceil($all / $pnumber);
        if (isset($_GET['last'])) $this->page = $this->num_pages;
        if ($this->page > $this->num_pages || $this->page < 1) $this->page = 1;
        if ($all) {
	        $this->start = $this->page * $pnumber - $pnumber;
	        $this->end = ($end = $this->start + $pnumber) > $all ? $all : $end;
	        $this->limit = sprintf('LIMIT %s,%s', $this->start, $pnumber);
		}
        // Для совместимости со старой версией навигатора
        $this->pnumber = $pnumber;
    }

	function form()
	{
		return ($this->num_pages < 2) ? '' : sprintf($this->htmlForm, $this->skript, $this->page);
	}

	function button()
    {
    	$back = $this->page > 1 ? sprintf($this->buttonBack, $this->skript, $this->page-1) : '';
    	$forward = $this->page != $this->num_pages ? sprintf($this->buttonForward, $this->skript, $this->page+1) : '';
    	return ($this->num_pages < 2) ? '' : $back . $this->separator . $forward;
    }

    function str()
    {
    	$buff = '';
        for($pr = '', $i = 1; $i <= $this->num_pages; $i++) {
            $buff .= $pr = (($i == 1 || $i == $this->num_pages || abs($i - $this->page) < 3) ? ($i == $this->page ? '<span class="selected">'.$i.'</span>' : sprintf(' <span class="next"><a href="%spage=%s">%2$s</a></span> ', $this->skript, $i)) : (($pr == ' ... ' || $pr == '') ? '' : ' ... '));
        }
        return ($this->num_pages < 2) ? '' :  sprintf($this->listStr, $buff, $this->skript, ($this->page != $this->num_pages ? $this->page+1 : $this->page) );
    }

    function navi($str = true, $button = true, $form = true)
    {
        $str = $str ? $this->str() : '';
        $button = $button ? $this->button() : '';
        $form = ($form AND  $this->num_pages >= 3) ? $this->form() : '';
        return sprintf($this->blocAllNavi, $button, $str, $form);
    }

}

?>